/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRegistryKey.h,v 1.3 1999/10/06 06:41:01 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CRegistryKey_h	// [
#define Included_CRegistryKey_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Types

class CString;


// Class CRegistryKey

class CRegistryKey
{
	NOT_COPYABLE(CRegistryKey)

public:
	CRegistryKey() : mIsOpened(FALSE), mHKey(NULL) { }
	~CRegistryKey();

	operator HKEY() {return mHKey;}
	operator const HKEY() const {return mHKey;}

	PGPBoolean	IsOpened() const {return mIsOpened;}

	void	Open(HKEY root, const char *section, REGSAM security = 
		KEY_ALL_ACCESS);
	void	Create(HKEY root, const char *section, REGSAM security = 
		KEY_ALL_ACCESS);
	void	Close();

	PGPUInt32	GetValue(const char *valueName, PGPByte *buf, 
		PGPUInt32 sizeBuf) const;
	PGPBoolean	EnumValues(PGPUInt32 index, CString& valueName, 
		PGPUInt32& valueType) const;
	PGPBoolean	EnumSubkeys(PGPUInt32 index, CString& subkeyName) const;

	void	SetValue(const char *valueName, const PGPByte *data, 
		PGPUInt32 sizeData, PGPUInt32 dataType) const;
	void	DeleteValue(const char *valueName) const;
	void	DeleteSubkey(const char *subkeyName, 
		PGPBoolean recursive = FALSE) const;

private:
	PGPBoolean	mIsOpened;
	HKEY		mHKey;
};

_PGP_END

#endif	// Included_CRegistryKey_h
